//
//  MCReportUserInputAbstractView.h
//  MCReporting
//
//  Created by Alykhan Jetha on 07/03/06.
//  Copyright 2006 Marketcircle Inc.. All rights reserved.
//

#import <MCApplication/MCNibLoadingView.h>

@class MCReportUserInputView;

@interface MCReportUserInputAbstractView : MCNibLoadingView {
	IBOutlet NSObjectController *objectController;
	NSMutableDictionary *localConfiguration;

}

- (void)configureWithDictionary:(NSDictionary *)dict;

- (NSMutableDictionary *)localConfiguration;
- (void)setLocalConfiguration:(NSMutableDictionary *)aLocalConfiguration;

// give subclasses chance to resize height if needed
- (void)sizeToFit;

// give subclasses chance to do additional setup (content on object controller already set at this time)
- (void)didSetLocalConfiguration;

- (BOOL)validateUserInput;

- (void)putUserInputIntoDictionary:(NSMutableDictionary *)aDict;
- (void)takeUserInputFromDictionary:(NSDictionary *)aDict;

- (MCReportUserInputView *)userInputSuperview;

- (NSString *)userDefaultsSubKey;
- (NSString *)basicDefaultsName;

@end


@interface MCReportUserInputViewHelper : NSObject

/**
 Returns a NSCalendarDate object in a dictionary with the given key. Returns nil if not found.
 */
+ (NSCalendarDate *)calendarDateFromDictionary:(NSDictionary *)dictionary forKey:(NSString *)key;

@end
